Scriptname SuH_Main_Player extends ReferenceAlias  

;	SuH_Main_Player : Player Alias from SuH_Main : is the dedicated player script and also acts as a repeating timer script. This manages any functions which are ran via script timers or are ran on the Player Reference, such as onHit when the player is hit, or onEquip when the player consumes Succubus Heart items.

SuH_Main property _m auto
SuH_MCM property _c auto
SuH_Fun property _f auto
SuH_Status property _s auto

SexLabFramework property SexLab auto

;	Variables
actor playerRef
float gametimelast ; Last GameDaysPassed grabbed
float gametimedelta ; Time in hours since last OnUpdate/Poll

bool isregupdates = false

bool PCreganim = false ; PC Registered for Animation : false=no true=yes
bool PCinanim = false ; PC in Animation : false=no true=yes
bool PCorgasmed = false ; Has PC Orgasmed in current anim , false=no true=yes
int PCanimtype ; 0=error , 1=Solo 2=Consentual , 3=is_victim , 4=is_aggressor
actor[] actdraintarget ; NPCs in act (targets for drain)
int[] actdraintargettype ; 0=error , 1=Solo? , 2=Consentual , 3=is_victim , 4=is_aggressor
int PCdraincount = 0 ; Drain count in this animation
float drainHealth = 0.0 ; Drain stat current values
float drainMagicka = 0.0
float drainStamina = 0.0
int PCarousalhighdecaydelay = 0 ; tick delay added to arousal decay computations
;int PCarousalpetassaultbuildup = 0 ; building amount from high arousal pet assault
;int PCarousalpetassaultreverse = 0 ; reverse rate, if above 0 buildup will decrease instead of increase
int PCarousaldamagebuildup = 0 ; building amount from high arousal starved damage
int giftedconsentbuildup = 0 ; building amount for gifted consent passive, at 10 (5sec) apply effect
int formalbeautybuildup = 0 ; You know the drill...
int overcapbuildup = 0
int deathoverridebuildup = 0
int drainvisualsbuildup = 0
int masochistbuildup = 0
int cumoverlaybuildup = 0
int lustfulbuildup = 0
int draindelay = 0 ; delay drain from taking effect
actor[] attackedByActorArray ; Collects current and previous attackers in an array, caps at 5 actors (0-1-2-3-4)
bool OnHitProcessing = false; OnHit processing bool, if true then skip processing onhit since it's already being processed
int CScooldown = 0 ; Combat Seduction Cooldown
int regalglowarmor = 0 ; Regal Glow ID
Worldspace playerworldspace ; Last detected worldspace


Event OnInit()
	_s = Game.GetFormFromFile(0x16E496, "Succubus Heart.esp") as SuH_Status
	_f = Game.GetFormFromFile(0x814, "Succubus Heart.esp") as SuH_Fun
	_m = Game.GetFormFromFile(0x801, "Succubus Heart.esp") as SuH_Main
	_c = Game.GetFormFromFile(0x802, "Succubus Heart.esp") as SuH_MCM
	SexLab = _s.SexLab
	playerRef = _s.playerRef
	;RegisterForSingleupdate(1.0) ; Tick in 1 second
	gametimelast = Utility.GetCurrentGameTime()
	isregupdates = true
	StartupCycle()
endEvent

Event OnPlayerLoadGame()
	_s = Game.GetFormFromFile(0x16E496, "Succubus Heart.esp") as SuH_Status
	_f = Game.GetFormFromFile(0x814, "Succubus Heart.esp") as SuH_Fun
	_m = Game.GetFormFromFile(0x801, "Succubus Heart.esp") as SuH_Main
	_c = Game.GetFormFromFile(0x802, "Succubus Heart.esp") as SuH_MCM
	
	if _s.SuH_MODversion > 0
		_m.MODupdate()
		_c.MCMupdate()
		isregupdates = true
	endIf
	StartupCycle()
endEvent

Function StartupCycle()
	int fwork = _s.SuH_framework
	SexLab = _s.SexLab
	playerRef = _s.playerRef
	if fwork == 1 ; SexLab
		_s.SuH_PCSgender = _s.SexLab.GetGender(playerRef)
	elseif fwork == 2 ; OStim
		_s.SuH_PCSgender = playerRef.GetActorBase().GetSex()
	endIf
	attackedByActorArray = new actor[5]
	
	MPupdate() ; Run update function
	
	RegisterForSingleupdate(1.0) ; Tick in 1 second
	gametimelast = Utility.GetCurrentGameTime()
	;	Unregister in-case they got stuck
		UnRegisterForModEvent("PlayerTrack_Added")
		UnRegisterForModEvent("PlayerTrack_Start")
		UnRegisterForModEvent("PlayerTrack_Orgasm")
		UnRegisterForModEvent("PlayerTrack_End")
		UnRegisterForModEvent("ostim_thread_start")
		UnRegisterForModEvent("ostim_actor_orgasm")
		UnRegisterForModEvent("ostim_thread_end")
	if _s.SuH_Frame_SexLab > 0 ; SexLab
		RegisterForModEvent("PlayerTrack_Added","anim_PC_Added_SL")
		RegisterForModEvent("PlayerTrack_Start","anim_PC_Start_SL")
		RegisterForModEvent("PlayerTrack_Orgasm","anim_PC_Orgasm_SL")
		RegisterForModEvent("PlayerTrack_End","anim_PC_End_SL")
	endif
	if _s.SuH_Frame_OStim > 0 ; OStim
		RegisterForModEvent("ostim_thread_start","anim_PC_Start_OS")
		RegisterForModEvent("ostim_actor_orgasm","anim_PC_Orgasm_OS")
		RegisterForModEvent("ostim_thread_end","anim_PC_End_OS")
	endIf
endFunction

Function MPupdate() ; Update Function
	if _s.SuH_MPversion < 5003005
		UnRegisterForModEvent("ostim_start")
		UnRegisterForModEvent("ostim_orgasm")
		UnRegisterForModEvent("ostim_thread_orgasm")
		UnRegisterForModEvent("ostim_end")
		_s.SuH_MPversion = 5003005
	endIf
endFunction

Event OnUpdate() ; OnUpdate
if (!Utility.IsInMenuMode()) && _s.SuH_runupdates == true
	;	Dynamic Script Fallback (For when SPID is disabled)
	if _s.SuH_SETdynaspid == 0
		If PlayerRef.HasSpell(_s.SuH_dyna_ability) ; If dynamic script is applying
			PlayerRef.RemoveSpell(_s.SuH_dyna_ability) ; Remove dynamic run script
		else ; if dynamic script is not applying
			PlayerRef.AddSpell(_s.SuH_dyna_ability, FALSE) ; AddSpell dynamic run script
		endIf
	EndIf

	;	GameTime
	float gamedays = Utility.GetCurrentGameTime() ; get Game Days Passed
	_s.SuH_currentgameday = Math.Floor(gamedays)
	gametimedelta = ((gamedays - gametimelast) * 24) ; Get gametime change and convert to hours
	gametimelast = gamedays
	
	;	Arousal
	int arousalstate = _s.SuH_PCSarousalstate
	int arousaltoadd = 0
	if arousalstate < 2
		arousaltoadd = Math.ceiling(_s.SuH_PCSarousalgain * gametimedelta) ; Adjust arousal gain for gametimedelta
	elseif arousalstate < 4
		arousaltoadd = Math.ceiling((_s.SuH_PCSarousalgain * gametimedelta) * 0.8) ; Adjust arousal gain for gametimedelta
	else ; arousalstate == 4
		arousaltoadd = Math.ceiling((_s.SuH_PCSarousalgain * gametimedelta) * 0.5) ; Adjust arousal gain for gametimedelta
	endIf
	_f.PC_addArousal(arousaltoadd) ; Add Arousal from Arousal Gain
	
	;	In Animation
	if PCinanim == true; if PC in animation
		;	PCanimtype ; 0=error , 1=Solo 2=Consentual 3=is_victim 4=is_aggressor
		if PCanimtype > 1 ; if player is not solo
			;	Calculate XP Gain
			int x = Math.floor(4 + (0.2 * playerRef.GetLevel()))
			_f.PC_addHeartXP( (( x + (x * (_s.SuH_PCSarousal / _s.SuH_PCSarousaltarget)))) )
			;	Calculate drain amount and set do not drain flag
			draindelay += 1
			if draindelay >= 2 ; trigger drain for every 2 seconds
				bool doNotReduce = false
				if PCdraincount == 0 ; if first drain pass
					if PCanimtype == 2 && _s.SuH_rank_giftedconsentplus > 0 ; if consentual and Gifted Consent+ is active
						if _s.SuH_PCSarousalstate == 0 ; If Exhausted, halve drain on-top of decrease
							drainHealth = ((drainHealth * 0.1) * 0.5)
							drainMagicka = ((drainMagicka * 0.1) * 0.5)
							drainStamina = ((drainStamina * 0.1) * 0.5)
						else ; apply normal decrease
							drainHealth = (drainHealth * 0.1)
							drainMagicka = (drainMagicka * 0.1)
							drainStamina = (drainStamina * 0.1)
						endIf
						doNotReduce = true
					elseif _s.SuH_PCSarousalstate == 0 ; if Exhausted reduce initial drain
						drainHealth = (drainHealth * 0.5)
						drainMagicka = (drainMagicka * 0.5)
						drainStamina = (drainStamina * 0.5)
					endIf
				else ; if past the first drain pass
					if PCanimtype == 2 && _s.SuH_rank_giftedconsentplus > 0 ; Disable drain if Gifted Consent+ procs
						doNotReduce = true
					endIf
					drainHealth = (drainHealth * 0.8) ; Lose 20% per-drain count till 0
					drainMagicka = (drainMagicka * 0.8)
					drainStamina = (drainStamina * 0.8)
				endIf
				if drainHealth > 0.5 || drainMagicka > 0.5 || drainStamina > 0.5  ; If drain is possible
					PCdraincount += 1
					;	Drain targets
					int i = 0
					while i < actdraintarget.Length
						actor actortarget = actdraintarget[i]
						if actortarget != none
							if drainHealth > 0.5
								_f.drainStat_Health(Math.ceiling(drainHealth), playerRef, actortarget, doNotReduceStatus=doNotReduce)
							endIf
							if drainMagicka > 0.5
								_f.drainStat_Magicka(Math.ceiling(drainMagicka), playerRef, actortarget, doNotReduceStatus=doNotReduce)
							endIf
							if drainStamina > 0.5
								_f.drainStat_Stamina(Math.ceiling(drainStamina), playerRef, actortarget, doNotReduceStatus=doNotReduce)
							endIf
						endIf
						i += 1
					endWhile
					_f.PCE_stattrack("PCdraintarget")
					if _s.SuH_SETdrainvisualinact > 0 && _s.SuH_PCSdraincount > 0; if drain visuals in act are enabled
						drainvisualsbuildup += 1
						if drainvisualsbuildup > 2 ; if drained for 3 ticks
							int k = 0
							while k < actdraintarget.Length
								if actdraintarget[k] != none
									_s.SuH_com_absorbvisuals.cast(playerRef, actdraintarget[k])
								endIf
								k += 1
							endWhile
							drainvisualsbuildup = 0
						endIf
					endIf
				endIf
				draindelay = 0
			endIf
			_f.PC_addSexBonus( Math.ceiling(10 + (_s.SuH_rank_selfstacker * 0.25)) ) ; Add SexBonus Time, +5% per self indulgent rank
			if PCanimtype == 2 && _s.SuH_rank_giftedconsent > 0 ; Apply Gifted Consent
				giftedconsentbuildup += 1
				if giftedconsentbuildup >= 5 ; Apply every 5 seconds
					int i = 0
					while i < actdraintarget.Length ; Apply for all partners
						actor actortarget = actdraintarget[i]
						actdraintarget[i].SetActorValue("Health", (actortarget.GetBaseActorValue("Health") + _s.SuH_rank_giftedconsent))
						actdraintarget[i].SetActorValue("Magicka", (actortarget.GetBaseActorValue("Magicka") + _s.SuH_rank_giftedconsent))
						actdraintarget[i].SetActorValue("Stamina", (actortarget.GetBaseActorValue("Stamina") + _s.SuH_rank_giftedconsent))
						i += 1
					endWhile
					_f.PCE_stattrack("Giftedconsent")
					giftedconsentbuildup = 0
				endIf
			endIf
		else ; If player is solo
			int x = Math.floor(1 + (0.1 * playerRef.GetLevel()))
			_f.PC_addHeartXP( (( x + (x * (_s.SuH_PCSarousal / _s.SuH_PCSarousaltarget)))) )
			if _s.SuH_rank_selfstackerplus > 0
				_f.PC_addSexBonus( Math.ceiling(10 + (_s.SuH_rank_selfstacker * 0.25)) ) ; Add SexBonus Time, +5% per self indulgent rank
			endIf
		endIf
		if PCorgasmed == false ; If player hasn't orgasmed in this animation, add arousal
			_f.PC_addArousal(20)
		endIf
	else ; Not in animation
		;	Decay Sex Bonus
		_f.PC_addSexBonus( (Math.ceiling( (-1 * (_s.SuH_PCSsexbonushour * gametimedelta)))) ) ; Adjust decay for gametimedelta
		
		;	Decay Fluid Bonus
		_f.PC_addFluidBonus( (Math.ceiling( (-1 * (_s.SuH_PCSfluidbonushour * gametimedelta)))) ) ; Adjust decay for gametimedelta
		
		;	Check Max Status + decay if above
		overcapbuildup += 1 ; Add build up
		if overcapbuildup >= (1 + _s.SuH_rank_capexcel2) ; if buildup exceeds cap excel allowance
			if _s.SuH_rank_capexcelplus == 0 || _s.SuH_PCSsexbonus < 1 ; if cap excel plus isn't unlocked and sex bonus is not active
				_f.PC_checkstatusmax() ; check max status
			endIf
			overcapbuildup = 0 ; reset buildup
		endIf
		
		arousalstate = _s.SuH_PCSarousalstate
		;	Arousal Negative Effects
		if _s.SuH_SETarousaldefect > 0
			if arousalstate >= 2 ; if Craving or above
				PCarousalhighdecaydelay += 1 ; add counter to delay
				if PCarousalhighdecaydelay >= (60 / (arousalstate - 1)) ; 60sec > 30sec > 20sec
					_f.PC_addHealthMax(-1, skillXPconvert=true)
					_f.PC_addMagickaMax(-1, skillXPconvert=true)
					_f.PC_addStaminaMax(-1, skillXPconvert=true)
					PCarousalhighdecaydelay = 0
				endIf
			endIf
			;if arousalstate >= 3 ; if Withdrawl or above - Currently no effects, uncomment when adding a new effect
			
				;MOVED TO spell_Pet - Pet Assault Chance
				; if _s.SuH_actor_activepet != none
					; int rand = Utility.RandomInt(0,500) ; Random build-up
					; if PCarousalpetassaultreverse > 0 ; If we're reversing buildup
						; PCarousalpetassaultbuildup -= (rand * PCarousalpetassaultreverse)
					; else ; if we're building up
						; PCarousalpetassaultbuildup += rand
						; if PCarousalpetassaultbuildup >= 15000 ; min-time of 30 seconds
						;	trigger anim
							; if _s.Sexlab.ValidateActor(_s.SuH_actor_activepet) > 0 && _s.Sexlab.ValidateActor(playerRef) > 0
								; actor[] animActor = new actor[2]
								; animActor[0] = _s.PlayerRef
								; animActor[1] = _s.SuH_actor_activepet
								; if _f.Scene_StartThread(animActor) < 0
									; PCarousalpetassaultbuildup -= 500 ; if anim failed, reduce buildup to try again
								; else
									; PCarousalpetassaultreverse = 2 ; if anim started, Set Reverse Buildup
								; endIf
							; endIf
						; endIf
					; endIf
				; endIf
				
			;endIf
			if arousalstate >= 4 ; if Starved
				int rand = Utility.RandomInt(0,200)
				PCarousaldamagebuildup += rand
				if PCarousaldamagebuildup > 400
					rand = Utility.RandomInt(0,2)
					if rand == 0
						if playerRef.GetActorValue("Health") > 19
							PlayerRef.DamageActorValue("Health", 10.0)
						else
							PlayerRef.DamageActorValue("Magicka", 10.0)
							PlayerRef.DamageActorValue("Stamina", 10.0)
						endIf
					elseif rand == 1
						PlayerRef.DamageActorValue("Magicka", 20.0)
					elseif rand == 2
						PlayerRef.DamageActorValue("Stamina", 20.0)
					endIf
					PCarousaldamagebuildup = 0
				endIf
			endIf
		
			;	Lustful effects (high arousal which seduces surrounding actors)
			if arousalstate >= 3 ; If Withdrawl or above
				lustfulbuildup += Utility.RandomInt(0,500) ; Random build-up
				if lustfulbuildup >= 120000 ; min-time of 2 minutes
					if _s.Sexlab.ValidateActor(_s.playerRef) > 0 ; if player is valid
						; Need to sert up checks for prefered gender based on enabled animations settings, like allowing homo or not
						int preferGender = -1
						actor foundactor = _s.SexLab.FindAvailableActor(playerRef, 2000.0, preferGender) ; center search on pet, 2000 radius, search for gender x, ignore player ;Actor IgnoreRef2 = none, Actor IgnoreRef3 = none, Actor IgnoreRef4 = none)
						
						if _s.Sexlab.ValidateActor(foundactor) > 0 ; if found actor is valid
							int m = 0
							if _s.SuH_SETpheromessage
								m = _s.SuH_menu_lustfultake.show()
							endIf
							if m == 0 ; Accept
								actor[] animActor = new actor[2]
								animActor[0] = playerRef
								animActor[1] = foundactor
								if _f.Scene_StartThread(animActor, playerRef) < 0 ; start aggressive animation
									lustfulbuildup = 0 ; if anim failed, reduce buildup to try again
								else
									lustfulbuildup = 0 ; if anim started, reset lust values
								endIf
							else ; Decline
								lustfulbuildup -= 50000
							endIf
						endIf
						
					endIf
				endIf
			endif
		endIf
		
		;	If Sex Bonus is active
		if _s.SuH_PCSsexbonus > 0
			if _s.SuH_rank_formalbeauty > 0 ; Formal Beauty Healing Passive
				formalbeautybuildup += 1
				if formalbeautybuildup >= 5 ; if it's been 5 seconds
					int x = Math.Floor(_s.SuH_rank_formalbeauty * (_s.SuH_PCSdpoint * 0.05))
					playerRef.RestoreActorValue("Health", x) ; +5% desire rating per rank
					formalbeautybuildup = 0
				endIf
			endIf
		endIf
		regalGlowCalc() ; Needs rewrite
		
		if deathoverridebuildup > 0 ; if we have DOM waiting, reduce build up
			deathoverridebuildup -= 1
			if deathoverridebuildup < 1
				if _s.SuH_CHKdied > 0 ; if DOM is waiting for respawn
					if _f.SDrespawn() == 0 ; if done waiting, try to respawn
						deathoverridebuildup += 5 ; if failed, try again in 5 ticks
					endIf
				endIf
			endIf
		endIf
		
		;	Check for player worldspace changes
		if PlayerRef.GetWorldSpace() != playerworldspace ; if worldspace changed
			playerworldspace = PlayerRef.GetWorldSpace()
			attackedByActorArray = new actor[5]
			
			; If active pet that's not in sexlab act and isn't in the same worldspace as the player
			if _s.SuH_actor_activepet != none && _s.SuH_actor_activepet.GetWorldSpace() != playerworldspace && ((_s.SuH_Frame_SexLab > 0 && _s.SexLab.ValidateActor(_s.SuH_actor_activepet) != -10) || _s.SuH_Frame_SexLab == 0)
					_s.SuH_actor_activepet.MoveTo(PlayerRef) ; Move pet to player
			endIf
			
			if playerworldspace != _s.SuH_worldspace ; If not in succubus realm
				if playerRef.GetWorldSpace() != _s.SuH_sd_returnpointcell.GetWorldSpace() ; if DOM cell return point isn't where player is
					_s.SuH_sd_returnpointcell.MoveTo(PlayerRef) ; Move DOM cell return point to player
				endIf
			endIf
		elseif playerworldspace == _s.SuH_worldspace ; if in Succubus Realm
			_f.Replicate_RunCalc()
		endIf
	endIf
	
	; Always run independant of animation state
	
	; Cooldown Management
	if masochistbuildup > 0 ; Masochist Passive Cooldown
		masochistbuildup -= 1
	endIf
	if CScooldown > 0 ; Combat Seduction Cooldown
		CScooldown -= 1
	endIf
	if _s.SuH_rank_violenceCD > 0 ; Violence Passive Cooldown
		_s.SuH_rank_violenceCD -= 1
	endIf
	
	; Recovery holder
	if _s.SuH_SETdisablehealthrecovery > 0
		playerRef.SetActorValue("HealRate", 0)
	endIf
	if _s.SuH_SETdisablemagickarecovery > 0
		playerRef.SetActorValue("MagickaRate", 0)
	endIf
	if _s.SuH_SETdisablestaminarecovery > 0
		playerRef.SetActorValue("StaminaRate", 0)
	endIf
	if cumoverlaybuildup > 0
		cumoverlaybuildup -= 1
	endif
endIf
	_s.SuH_MPlayertickcounter += 1 ; Increase processed count for stuck script processing
	RegisterForSingleupdate(1.0) ; Tick in 1 second
endEvent

function regalGlowCalc() ; Needs rewrite to simplify and optimize
	if _s.SuH_rank_regalglow > 0
		int RGarmor = _s.SuH_rank_regalglow
		int bodySlot = 0x00000004
		Armor bodyArmor = _s.playerRef.GetWornForm(bodySlot) as Armor
		;if bodyArmor == _f.SuH_armor_regalglow ;Regal Glow Active Already
		if (bodyArmor) ;Body Armor Found
			regalglowarmor = 0
			playerRef.UnequipItem(_s.SuH_armor_regalglow, abSilent=true)
		elseif playerRef.IsEquipped(_s.SuH_armor_regalglow) ;Regal Glow Active Already
			if RGarmor != regalglowarmor
				playerRef.UnequipItem(_s.SuH_armor_regalglow, abSilent=true)
				bodyArmor.SetArmorRating( Math.Floor(RGarmor * (_s.SuH_PCSmpoint * 0.05)))
				playerRef.equipitem(_s.SuH_armor_regalglow, false, true)
				regalglowarmor = RGarmor
			endIf
		else ;no body armor
			playerRef.equipitem(_s.SuH_armor_regalglow, false, true)
			;_s.SuH_armor_regalglow.SetArmorRating(RGarmor)
			bodyArmor.SetArmorRating( Math.Floor(RGarmor * (_s.SuH_PCSmpoint * 0.05)))
			playerRef.UnequipItem(_s.SuH_armor_regalglow, abSilent=true)
			playerRef.equipitem(_s.SuH_armor_regalglow, false, true)
			regalglowarmor = RGarmor
		endIf
	endIf
endFunction

;	Player Animation Added / Started
;		SL = SexLab
;		OS = OStim
Event anim_PC_Added_SL(form ActorRef, int threadId)
	;MiscUtil.PrintConsole("anim_PC_Added_SL")
	if _s.SuH_Frame_SexLab > 1
		actor[] animActor = _s.SexLab.HookActors(threadId)
		anim_PC_Added(animActor)
		;playerRef.SetRestrained(true)
		if _s.SuH_SETchangecontrol > 0
			Game.DisablePlayerControls(true, true, false, false, false, false, false, false, 0) ; abMovement,abFighting,abCamSwitch,abLooking,abSneaking,abMenu,abActivate,abJournalTabs,aiDisablePOVType
		endIf
	endIf
endEvent

Event anim_PC_Start_SL(form ActorRef, int threadId)
	;MiscUtil.PrintConsole("anim_PC_Start_SL")
	if _s.SuH_Frame_SexLab > 1
		actor[] animActor = _s.SexLab.HookActors(threadId)
		anim_PC_Start(animActor, 1, threadId) ; call start anim code
	endIf
endEvent

Event anim_PC_Start_OS(String EventName, String sceneId, Float threadId, Form Sender)
	;MiscUtil.PrintConsole("anim_PC_Start_OS ")
	if (threadId == 0 && _s.SuH_Frame_OStim > 1) ; If thread is player thread (always 0) and set to use OStim
		actor[] animActor = OThread.GetActors(0) ; Get actor array
		anim_PC_Added(animActor)
		anim_PC_Start(animActor, 2)
	endIf
endEvent

Function anim_PC_Added(actor[] animActor)
	;MiscUtil.PrintConsole("anim_PC_Added")
	if _s.SuH_runupdates == false
		return
	endif
	PCreganim = true
	
	int i = 0
	while i < animActor.Length
		animActor[i].StopCombatAlarm()
		i += 1
	endWhile
	
	if _s.SuH_SETcalmaura > 0 ; Calm during act setting
		playerRef.AddSpell(_s.SuH_dyna_calmaura, false)
	endIf
	
	If _s.SuH_SETspecialdeath > 0 
		if playerRef.IsBleedingOut() == True ; DOM wait for anim settings
			_s.SuH_CHKsdinact += 1
			Utility.Wait(0.05)
			playerRef.SetNoBleedoutRecovery(false)
			playerRef.RestoreActorValue("Health", 100) ; Recover for animation
			playerRef.StartDeferredKill() ; Start deferred kill to stop player from dying in act
			playerRef.DamageActorValue("Health", 99999999)
		else
			playerRef.StartDeferredKill() ; Start deferred kill to stop player from dying in act
		endIf
	elseif _s.SuH_SETpreventactdeath > 0
		playerRef.StartDeferredKill() ; Start deferred kill to stop player from dying in act
	endIf
	
endFunction

function anim_PC_Start(actor[] animActor, int fwork=0, int threadId=0)
	;MiscUtil.PrintConsole("anim_PC_Start")
	if _s.SuH_runupdates == false || fwork == 0
		return
	endif
	
	;playerRef.SetRestrained(false)
	
	;playerRef.StartDeferredKill() ; Start deferred kill to stop player from dying in act
	;	Reset Variables
	PCanimtype = 0
	PCdraincount = 0
	drainHealth = _s.SuH_PCSabsorbhealth as float
	drainMagicka =_s.SuH_PCSabsorbmagicka  as float
	drainStamina = _s.SuH_PCSabsorbstamina  as float
	_s.SuH_PCSdraincount = 0
	
	;	 Clear Arrows Option
	if _s.SuH_SETclearactor > 0
		playerRef.ClearExtraArrows()
	endIf
	
	;	Get Non-Player Actor List and determine type
	if animActor.Length > 1
		actdraintarget = new actor[4] ; Cap at 4, 5 SexLab limit minus player
		actdraintargettype = new int[4]
		int i = 0
		int h = 0
		while i < animActor.Length
			actor animActorFound = animActor[i]
			if animActorFound != playerRef ; if not player
				if animActorFound.IsInFaction(_s.SuH_ignoreabsorb)
					debug.Notification("Succubus Heart : This one is immune to drain...")
				endIf
				actdraintarget[h] = animActorFound ; Add actor to target actor array
				if fwork == 1 ; SexLab
					if SexLab.IsVictim(threadId, animActorFound) ; if is victim
						actdraintargettype[h] = 3 ; target is victim
					elseif SexLab.IsAggressor(threadId, animActorFound) ; if is aggressor
						actdraintargettype[h] = 4 ; target is aggressor
					else
						actdraintargettype[h] = 2 ; target is consensual
					endIf
				elseif fwork == 2 ; OStim - Incomplete
					actdraintargettype[h] = 2 ; target is consensual
				endIf
				 h += 1
			endIf
			i += 1
		endWhile
	else
		PCanimtype = 1 ; Player is in solo act
	endIf
	
	if PCanimtype != 1 ; if player is not solo
		if fwork == 1 ; SexLab
			if SexLab.IsVictim(threadId, playerRef)
				PCanimtype = 3 ; player is victim
			elseIf SexLab.IsAggressor(threadId, playerRef)
				PCanimtype = 4 ; player is aggressor
			else
				PCanimtype = 2 ; player is consensual
			endIf
		elseIf fwork == 2 ; OStim
			PCanimtype = 2 ; player is consensual
		endIf
	endIf
	
	PCinanim = true ; Set player in anim
endFunction

;	Player Orgasm
;		SL = SexLab
;		OS = OStim
Event anim_PC_Orgasm_SL(form ActorRef, int threadId)
	;MiscUtil.PrintConsole("anim_PC_Orgasm_SL")
	if _s.SuH_Frame_SexLab > 1
		actor[] animActor = _s.SexLab.HookActors(threadId)
		anim_PC_Orgasm(animActor)
	endIf
endEvent

Event anim_PC_Orgasm_OS(String EventName, String sceneId, Float threadID, Form Sender)
	;MiscUtil.PrintConsole("anim_PC_Orgasm_OS")
	if (threadID == 0 && _s.SuH_Frame_OStim > 1)
		actor[] animActor = OThread.GetActors(0)
		anim_PC_Orgasm(animActor)
	endif
endEvent

function anim_PC_Orgasm(actor[] animActor)
	;MiscUtil.PrintConsole("anim_PC_Orgasm")
	if _s.SuH_runupdates == false
		return
	endif
	
	if animActor.Length > 1 ; Act is not solo
		;	Hand out Fluids
		if _s.SuH_PCSgender == 0 && _s.SuH_SETspermdistribute > 0 ; if male and sperm dist true
			int i = 0
			while i < animActor.Length
				if animActor[i] != playerRef
					animActor[i].AddItem(_s.SuH_alch_spermsuccubus, 1, true)
				endif
				i += 1
			endWhile
		elseif _s.SuH_PCSgender == 1 && _s.SuH_SETmilkdistribute > 0 ; if female and milk dist true
			int i = 0
			while i < animActor.Length
				if animActor[i] != playerRef
					animActor[i].AddItem(_s.SuH_alch_milksuccubus, 1, true)
				endif
				i += 1
			endWhile
		endIf
		
		;	Calculate SuH_rank_perfectorgasm2 Death Drop Bonus
		int perforg2 = _s.SuH_rank_perfectorgasm2
		if perforg2 > 0
			int m = perforg2*5 ; passive effect strength
			int ranD = Utility.RandomInt(1,100)
			if ranD <= m
				int ran = Utility.RandomInt(0,49)
				if ran < 14
					_s.playerRef.AddItem(_s.SuH_alch_soulofforce, 1, false)
				elseIf ran < 28
					_s.playerRef.AddItem(_s.SuH_alch_soulofexperience, 1, false)
				elseIf ran < 41
					_s.playerRef.AddItem(_s.SuH_alch_soulofdesire, 1, false)
				elseIf ran < 44
					_s.playerRef.AddItem(_s.SuH_alch_souloflife, 1, false)
				elseIf ran < 47
					_s.playerRef.AddItem(_s.SuH_alch_soulofmagic, 1, false)
				elseIf ran < 50
					_s.playerRef.AddItem(_s.SuH_alch_soulofpower, 1, false)
				endIf
			endIf
		endIf
		_f.PCE_orgasm() ; Orgasm is with others
		if _s.SuH_SETdrainresetorgasm > 0 ; If Reset Drain on Orgasms is enabled
			drainHealth = _s.SuH_PCSabsorbhealth as float
			drainMagicka =_s.SuH_PCSabsorbmagicka  as float
			drainStamina = _s.SuH_PCSabsorbstamina  as float
			PCdraincount = 0
		endIf
	else ; Act is solo
		if _s.SuH_PCSgender == 0 && _s.SuH_SETspermdistribute > 0 ; if male and sperm dist true
			playerRef.AddItem(_s.SuH_alch_spermsuccubus, 1, true)
		elseif _s.SuH_PCSgender == 1 && _s.SuH_SETmilkdistribute > 0 ; if female and milk dist true
			playerRef.AddItem(_s.SuH_alch_milksuccubus, 1, true)
		endIf
		_f.PCE_orgasm(true) ; Orgasm is solo
	endIf
	PCorgasmed = true
endFunction

;	Player Animation End
;		SL = SexLab
;		OS = OSTim
Event anim_PC_End_SL(form ActorRef, int threadId)
	;MiscUtil.PrintConsole("anim_PC_End_SL")
	if _s.SuH_Frame_SexLab > 1
		anim_PC_End()
	endIf
	;if _s.SuH_SETchangecontrol > 0
	;	Game.DisablePlayerControls(false, false, false, false, false, false, false, false, 0) ; abMovement,abFighting,abCamSwitch,abLooking,abSneaking,abMenu,abActivate,abJournalTabs,aiDisablePOVType
	;endIf
endEvent

Event anim_PC_End_OS(String EventName, String sceneId, Float threadID, Form Sender)
	;MiscUtil.PrintConsole("anim_PC_End_OS")
	if (threadID == 0 && _s.SuH_Frame_OStim > 1)
		anim_PC_End()
		actor[] animActor = new actor[5]
		animActor[0] = playerRef
		animActor[1] = actdraintarget[0]
		animActor[2] = actdraintarget[1]
		animActor[3] = actdraintarget[2]
		animActor[4] = actdraintarget[3]
		anim_PC_End_OStimExtra(animActor)
	endif
endEvent

function anim_PC_End_OStimExtra(actor[] animActor)
	int i = 1
	while i < animActor.Length
		if animActor[i] != none
			;MiscUtil.PrintConsole("SUH Player END Send "+i+" is Valid")
			_m.anim_NPC_End(animActor[i], animActor, true)
		else
			;MiscUtil.PrintConsole("SUH Player END Send "+i+" is Invalid")
		endIf
		i += 1
	endWhile
endFunction

function anim_PC_End()
	;MiscUtil.PrintConsole("anim_PC_End")
	if _s.SuH_runupdates == false
		return
	endif
	if _s.SuH_SETpreventactdeath > 0 || _s.SuH_SETspecialdeath > 0
		playerRef.EndDeferredKill() ; End Deferred Kill
	endIf
	PCreganim = false
	PCinanim = false
	PCorgasmed = false
	PCanimtype = 0
	playerRef.RemoveSpell(_s.SuH_dyna_calmaura) ; Remove calm during act
	
	if _s.SuH_SETcscooldown > 0 ; Combat seduction set cooldown
		CScooldown += _s.SuH_SETcscooldown
	endIf
		;	Drain Visuals if Drained
	if _s.SuH_PCSdraincount > 0
		int i = 0
		while i < actdraintarget.Length
			if actdraintarget[i] != none
				_s.SuH_com_absorbvisuals.cast(playerRef, actdraintarget[i])
			endIf
			i += 1
		endWhile
		_s.SuH_PCSdraincount = 0
	endIf
endFunction

Event OnObjectEquipped(Form akBaseObject, ObjectReference akReference)
	if _s.SuH_runupdates == false
		return
	endif
	if akBaseObject.HasKeyword(_s.SuH_key_sperm)
		_f.PCE_consumesperm(1)
		if cumoverlaybuildup < 1
			cumoverlaybuildup = 5
			if _s.SuH_Frame_SexLab > 0 ; SexLab
				_s.SexLab.AddCum(playerRef, false, true, false)
			endif
		endIf
	elseif akBaseObject.HasKeyword(_s.SuH_key_milk)
		_f.PCE_consumemilk(1)
	elseif akBaseObject.HasKeyword(_s.SuH_key_incxpgain)
		_s.SuH_PCSxpgain += 1
		_s.SuH_PCSxpgainitem += 1
		_f.PC_recalculateBDSM()
		Debug.Notification("Empowerment Stone - HeartXP gain increased by 1%")
	elseif akBaseObject.HasKeyword(_s.SuH_key_incdesire)
		_f.PC_addArousal( Math.Floor(_s.SuH_PCSarousaltarget * 0.5) )
		debug.Notification("Soul of Desire - Lust increased by 50%")
	elseif akBaseObject.HasKeyword(_s.SuH_key_incxp)
		int x = (100 + (50 * playerRef.GetLevel()))
		int y = _f.PC_addHeartXP(x)
		debug.Notification("Soul of Experience - "+y+" HeartXP Granted")
	elseif akBaseObject.HasKeyword(_s.SuH_key_incforce)
		_f.PC_addSkillXP(200)
		debug.Notification("Soul of Skill - Granted 200 SkillXP")
	elseif akBaseObject.HasKeyword(_s.SuH_key_inccaphealth)
		_s.SuH_PCScaphealth += 1
		_s.SuH_PCScaphealthitem += 1
		_f.PC_recalculateBDSM()
		debug.Notification("Soul of Life - Granted 1 Health Cap")
	elseif akBaseObject.HasKeyword(_s.SuH_key_inccapmagicka)
		_s.SuH_PCScapmagicka += 1
		_s.SuH_PCScapmagickaitem += 1
		_f.PC_recalculateBDSM()
		debug.Notification("Soul of Magic - Granted 1 Magicka Cap")
	elseif akBaseObject.HasKeyword(_s.SuH_key_inccapstamina)
		_s.SuH_PCScapstamina += 1
		_s.SuH_PCScapstaminaitem += 1
		_f.PC_recalculateBDSM()
		debug.Notification("Soul of Power - Granted 1 Stamina Cap")
	elseif akBaseObject.HasKeyword(_s.SuH_key_incsp)
		_s.SuH_PCSskillxp += 800
		Debug.Notification("Specialty Stone - Granted 800 SkillXP")
	elseif akBaseObject.HasKeyword(_s.SuH_key_resetpassives)
		_f.PassiveReset(1)
		Debug.MessageBox("Refresh Stone - Passives Have Been Reset!")
	elseif akBaseObject.HasKeyword(_s.SuH_key_sperm25)
		_f.PCE_consumesperm(25)
		if cumoverlaybuildup < 1
			cumoverlaybuildup = 5
			if _s.SuH_Frame_SexLab > 0 ; SexLab
				_s.SexLab.AddCum(playerRef, false, true, false)
			endif
		endIf
	elseif akBaseObject.HasKeyword(_s.SuH_key_milk20)
		_f.PCE_consumemilk(20)
	elseif akBaseObject.HasKeyword(_s.SuH_key_incxp25)
		int x = ((100 + (50 * playerRef.GetLevel())) * 25)
		int y = _f.PC_addHeartXP(x)
		debug.Notification("Crystalized Experience - "+y+" HeartXP Granted")
	elseif akBaseObject.HasKeyword(_s.SuH_key_incforce25)
		_f.PC_addSkillXP(5000)
		debug.Notification("Crystalized Skill - Granted 5000 SkillXP")
	elseif akBaseObject.HasKeyword(_s.SuH_key_inccaphealth25)
		_s.SuH_PCScaphealth += 25
		_s.SuH_PCScaphealthitem += 25
		_f.PC_recalculateBDSM()
		debug.Notification("Crystalized Life - Granted 25 Health Cap")
	elseif akBaseObject.HasKeyword(_s.SuH_key_inccapmagicka25)
		_s.SuH_PCScapmagicka += 25
		_s.SuH_PCScapmagickaitem += 25
		_f.PC_recalculateBDSM()
		debug.Notification("Crystalized Magic - Granted 25 Magicka Cap")
	elseif akBaseObject.HasKeyword(_s.SuH_key_inccapstamina25)
		_s.SuH_PCScapstamina += 25
		_s.SuH_PCScapstaminaitem += 25
		_f.PC_recalculateBDSM()
		debug.Notification("Crystalized Power - Granted 25 Stamina Cap")
	elseif akBaseObject.HasKeyword(_s.SuH_key_inccapall)
		_s.SuH_PCScaphealth += 5
		_s.SuH_PCScapmagicka += 5
		_s.SuH_PCScapstamina += 5
		_s.SuH_PCScaphealthitem += 5
		_s.SuH_PCScapmagickaitem += 5
		_s.SuH_PCScapstaminaitem += 5
		_f.PC_recalculateBDSM()
		Debug.Notification("Vitality Stone - All status caps increased by 5")
	elseif akBaseObject.HasKeyword(_s.SuH_key_pet)
		actorbase soulactorbase = none
		if akBaseObject.HasKeyword(_s.SuH_key_petdog)
			soulactorbase = Game.GetFormFromFile(0x23A92, "Skyrim.esm") as ActorBase
		elseif akBaseObject.HasKeyword(_s.SuH_key_petskeever)
			soulactorbase = Game.GetFormFromFile(0x23AB7, "Skyrim.esm") as ActorBase
		elseif akBaseObject.HasKeyword(_s.SuH_key_petdraugr)
			soulactorbase = Game.GetFormFromFile(0x5593B, "Skyrim.esm") as ActorBase
		elseif akBaseObject.HasKeyword(_s.SuH_key_pethusky)
			soulactorbase = Game.GetFormFromFile(0x18B34, "Dawnguard.esm") as ActorBase
		elseif akBaseObject.HasKeyword(_s.SuH_key_petriekling)
			soulactorbase = Game.GetFormFromFile(0x17F47, "Dragonborn.esm") as ActorBase
		else
			return
		endIf
		_f.SoulPetAdd(none, false, akBaseObject, soulactorbase)
	endIf
endEvent

Event OnHit(ObjectReference akAggressor, Form akSource, Projectile akProjectile, bool abPowerAttack, bool abSneakAttack, bool abBashAttack, bool abHitBlocked)
	if OnHitProcessing == true || _s.SuH_runupdates == false ; If runupdates is not enabled or script is already processing (prevent overlap)
		return
	endif
	
	OnHitProcessing = true ; Set script as processing
	bool hostileProcess = false ; Set if hostile variable
	
	if akSource as Spell ; If hit is from a spell
		if (akSource as Spell).IsHostile() ; Check if spell is hostile
			hostileProcess = true ; set hostile
		else
			hostileProcess = false ; set non-hostile
		endIf
	else ; if not a spell hit, make hostile
		hostileProcess = true
	endIf
	
	if hostileProcess == true; If attack is hostile
		if _s.SuH_SETactendonatk == 1 && _s.SuH_Frame_SexLab > 0 
			if _s.SexLab.ValidateActor(playerref) == -10; If player is in act, stop act when hit
				sslThreadController Thread = _s.SexLab.ThreadSlots.GetActorController(playerRef) ; get scene thread
				_s.SexLab.ThreadSlots.StopThread(Thread) ; stop thread
			endIf
		endIf
		
		;	Masochist Passive
		if masochistbuildup < 1
			if _s.SuH_rank_masochist2 > 0 ; Gain stamina when hit if cooldown complete
				playerRef.RestoreActorValue("Stamina", ((_s.SuH_PCSbpoint * 0.1) * _s.SuH_rank_masochist2))
				masochistbuildup = 5 ; Cooldown in 5 seconds
			endIf
			if _s.SuH_rank_masochist > 0 ; Gain arousal when hit if cooldown complete
				_f.PC_addArousal( (Math.Floor(_s.SuH_PCSarousaltarget * 0.01) * _s.SuH_rank_masochist) )
				masochistbuildup = 5 ; Cooldown in 5 seconds
			endIf
			if _s.SuH_rank_masochist3 > 0 ; Gain HeartXP when hit if cooldown complete
				_f.PC_addHeartXP(Math.Floor((_s.SuH_PCSbpoint * 0.01) * _s.SuH_rank_masochist3))
				masochistbuildup = 5 ; Cooldown in 5 seconds
			endIf
		endIf
		
		;	Grab Status for next few processes
		float charBaseHealth = playerRef.GetBaseActorValue("health")
		float charHealthCurrent = playerRef.GetActorValue("health")
		float charHealthPercent = (charHealthCurrent / charBaseHealth)
		
		;	Saving Essence Passive
		if _s.SuH_rank_savingessence > 0 && _s.SuH_PCSfluidbonus > 0 && charHealthPercent <= 0.3
			PlayerRef.RestoreActorValue("Health", ( Math.Floor(_s.SuH_PCSbpoint * 0.05) *  _s.SuH_rank_savingessence)) ; Recover Health
			_f.PC_addFluidBonus(( (-1 * ((_s.SuH_PCSfluidbonushour * 5)) + (_s.SuH_PCSfluidbonushour * (_s.SuH_rank_savingessence2 / 3))) )) ; Subtract rank bonus (-1/3 hour) from cost (5 hour)
		endIf
		
		;	If hit by NPC
		Actor attChar = akAggressor as Actor ; Get damage source as actor
		if attChar != none && attChar != playerRef ; If attacker is an NPC
			;	store attackers
			int i = 0 ; scan attacked by array for current attacker
			while i < attackedByActorArray.Length
				if attackedByActorArray[i] == attChar ; if found attChar in array
					int k = i ; Set adjust array slot
					int x = 0 ; Set pull from array slot
					while k > 0 ; Until we are at slot 0
						x = k - 1
						attackedByActorArray[k] = attackedByActorArray[x] ; Move each entry up the array from arrayposition
						k -= 1
					endWhile
					attackedByActorArray[0] = attChar
					i = 999 ; escape while and set found attChar
				else
					i += 1
				endIf
			endWhile
			if i != 999 ; if we didn't find actor, shift full array up and add attChar
				attackedByActorArray[4] = attackedByActorArray[3]
				attackedByActorArray[3] = attackedByActorArray[2]
				attackedByActorArray[2] = attackedByActorArray[1]
				attackedByActorArray[1] = attackedByActorArray[0]
				attackedByActorArray[0] = attChar
			endIf
			
			;	Combat Seduction
			if _s.SuH_SETcombatseduction > 0 && CScooldown < 1 && ((_s.SuH_framework == 1 && _s.SexLab.ValidateActor(PlayerRef) > 0 && _s.SexLab.ValidateActor(attChar) > 0) || _s.SuH_framework == 2); If Combat Seduction is enabled and actors are valid
				charHealthCurrent = playerRef.GetActorValue("health") ; Recollect Current Health Passive in-case Seving Essence triggered
				charHealthPercent = (charHealthCurrent / charBaseHealth) ; Recollect Current Health Percentage in-case Seving Essence triggered
				float charStaminaCurrent = playerRef.GetActorValue("Stamina")
				float charStaminaBase = playerRef.GetBaseActorValue("Stamina")
				float charStaminaPercent = (charStaminaCurrent / charStaminaBase)
				
				if charHealthPercent <= _s.SuH_SETpc2npchealth && _s.SuH_SETpc2npchealth > 0.00 || charHealthCurrent <= _s.SuH_SETpc2npchealthmin && _s.SuH_SETpc2npchealthmin > 0.00 || charStaminaPercent <= _s.SuH_SETpc2npcstamina && _s.SuH_SETpc2npcstamina > 0.00 ; If status below threshholds
					int m = 0
					if _s.SuH_CSConfirmMessage
						m = _s.SuH_menu_csreceive.show()
					endIf
					if m == 0 ; Accept
					;if _s.SuH_CSanimprocessing == 0 ; Check if Combat Seduction is already trying to process an animation
					;	_s.SuH_CSanimprocessing = 1 ; set Combat Seduction as processing animation
						; Add in optional 3+ anim support
						
						;	basic 2 actor animation
						actor[] animActor = new actor[2] ; Create animActor array
						animActor[0] = playerRef
						animActor[1] = attChar
						if _f.Scene_StartThread(animActor, playerRef) < 1 ; Send aggressive animation
							debug.Notification("Combat Seduction - Scene failed to start!") ; if failed, report to player (Debug purposes)
						endIf
					;	_s.SuH_CSanimprocessing = 0 ; set Combat Seduction as open for another animation process
					;endIf
					else ; Decline
						if _s.SuH_SETcscooldown > 0
							playerRef.AddSpell(_s.SuH_sex_CScd, false)
						endIf
					endif
				endIf
			endIf
		endIf
	endIf
	OnHitProcessing = false ; Set script as no longer processing
endEvent

Event OnEnterBleedout()
	if PCreganim == true
		playerRef.SetNoBleedoutRecovery(false)
		playerRef.RestoreActorValue("Health", 100)
	endIf
	
	if _s.SuH_SETspecialdeath > 0 ; if DOM is enabled
		_s.SuH_CHKdied = 1
		if _s.SuH_CHKsdinact > 0 ; if already played animation
			deathoverridebuildup = 0
			if _f.SDrespawn() == 0	; respawn immediately (Add later support for multiple animations when Combat Seduction supports it)
				deathoverridebuildup += 5 ; if failed, try agian in 5 ticks
			endIf
		else
			if _s.SuH_SETcsbleedoutdelay > 0 ; if respawn delay is set above 0
				deathoverridebuildup += _s.SuH_SETcsbleedoutdelay ; add buildup to wait for respawn
			else
				if _f.SDrespawn() == 0 ; respawn immediately
					deathoverridebuildup += 5 ; if failed, try agian in 5 ticks
				endIf
			endIf
		endIf
	endIf
	;playerRef.StartDeferredKill()
endEvent